<?php get_header(); ?>

<!-- content START -->
<main>
    <section id="content" class="recipe-detail">
        <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

            <!-- Recipe Title -->
            <h1><?php the_title(); ?></h1>

            <!-- Recipe Content -->
            <?php the_content(); ?>

            <!-- Ingredients -->
            <h2>Ingredients</h2>
            <div class="lists">
                <?php for ($i = 1; $i <= 12; $i++):
                $img  = get_field("ingredient_{$i}_image");
                $name = get_field("ingredient_{$i}_name");
                $qty  = get_field("ingredient_{$i}_qty");
                if ( empty($img) && empty($name) && empty($qty) ) continue; ?>
                <ul>
                    <li>
                    <?php 
                    if ($img) {
                        if (is_array($img)) {
                        $img_url = $img['url'];
                        } else {
                        $img_url = $img;
                        }
                        echo '<img src="'.esc_url($img_url).'" alt="'.esc_attr($name ?: '').'">';
                    }
                    ?>
                    <?php if ($name): ?><p><?php echo esc_html($name); ?></p><?php endif; ?>
                    <?php if ($qty):  ?><p><?php echo esc_html($qty);  ?></p><?php endif; ?>
                    </li>
                </ul>
                <?php endfor; ?>
            </div>

            <!-- Step-By-Step -->
            <h2>Step-By-Step Guide</h2>
            <div class="steps-container">
                <?php for ($s = 1; $s <= 12; $s++):
                $simg = get_field("step_{$s}_image");
                $stxt = get_field("step_{$s}_description");
                if ( empty($simg) && empty($stxt) ) continue; ?>
                <div class="steps">
                    <h3>Step <?php echo $s; ?></h3>
                    <?php 
                    if ($simg) {
                    if (is_array($simg)) {
                        $simg_url = $simg['url'];
                    } else {
                        $simg_url = $simg;
                    }
                    echo '<img src="'.esc_url($simg_url).'" alt="Step '.esc_attr($s).'">';
                    }
                    ?>
                    <?php if ($stxt): ?>
                    <?php echo wp_kses_post( wpautop($stxt) ); ?>
                    <?php endif; ?>
                </div>
                <?php endfor; ?>
            </div>

            <!-- Notes -->
            <h2>Notes</h2>
            <dl>
                <?php for ($n = 1; $n <= 10; $n++):
                $nt = get_field("note_{$n}_title");
                $nd = get_field("note_{$n}_text");
                if ( empty($nt) && empty($nd) ) continue; ?>
                <?php if ($nt): ?><dt><?php echo esc_html($nt); ?> :</dt><?php endif; ?>
                <?php if ($nd): ?><dd><?php echo esc_html($nd); ?></dd><?php endif; ?>
                <?php endfor; ?>
            </dl>

            <!-- Navigation -->
            <nav class="recipe-nav">
                <?php previous_post_link('%link','&#8592; Previous Chai', true, '', 'category'); ?>
                <?php next_post_link('%link','Next Chai &#8594;', true, '', 'category'); ?>
                <a href="<?php echo esc_url( home_url('/chai-recipes') ); ?>">Back To Recipes</a>
            </nav>

        <?php endwhile; endif; ?>
    </section>
</main>

<?php get_footer(); ?>