<?php
/*
Template Name: Chai Recipes
*/
?>

<?php get_header(); ?>

<main>
  <section id="content" class="category">

    <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
      <h1><?php the_title(); ?></h1>
      <?php the_content(); ?>
    <?php endwhile; endif; ?>

    <?php
    // Define custom orders for categories
    $custom_orders = array(
        'chai-with-spices' => array(62, 166, 175, 182, 199, 201, 203, 205),
        'chai-with-herbs-leaves' => array(210, 212, 214, 216, 219, 221),
        'regional-and-specialty-chais' => array(232, 234, 236, 238, 240, 242)
    );

    foreach ( $custom_orders as $slug => $ids ) :

        $category = get_category_by_slug( $slug );
        if ( !$category ) continue;

        echo '<h2>' . esc_html( $category->name ) . '</h2>';
        echo '<ul>';

        $recipes = new WP_Query(['post_type' => 'post','posts_per_page' => -1,'orderby' => 'post__in','post__in' => $ids]);

        if ( $recipes->have_posts() ) :
            while ( $recipes->have_posts() ) : $recipes->the_post(); ?>
                <li>
                    <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
                        <?php if ( has_post_thumbnail() ) {
                            the_post_thumbnail( 'medium' );
                        } ?>
                        <p><?php the_title(); ?></p>
                    </a>
                </li>
            <?php endwhile;
        endif;

        wp_reset_postdata();
        echo '</ul>';

    endforeach;
    ?>

  </section>
</main>

<?php get_footer(); ?>