<?php
/*
Template Name: Health Benefits
*/
get_header(); ?>

<!-- content START -->
<main>
    <section id="content" class="benefits">
        <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
            <h1><?php the_title(); ?></h1>
            <?php the_content(); ?>
        <?php endwhile; endif; ?>

        <!-- Warming Spices -->
        <input type="checkbox" id="warming-spices">
        <label for="warming-spices">
            <h2>warming spices</h2>
        </label>
        <div class="accordion-content">
            <?php for ($i = 1; $i <= 20; $i++): 
                $image       = get_field("warming_spice_{$i}_image");
                $name        = get_field("warming_spice_{$i}_name");
                $description = get_field("warming_spice_{$i}_description");
                $benefits    = get_field("warming_spice_{$i}_benefits");

                // Skip empty items
                if (empty($name) && empty($image) && empty($description) && empty($benefits)) continue;
            ?>
                <div class="ingredient-item">
                    <div class="ing-content">
                        <div class="ing-img">
                            <?php 
                            if ($image) {
                                if (is_array($image)) {
                                    $img_url = $image['url'];
                                    $img_alt = $image['alt'] ?: $name;
                                } else {
                                    $img_url = $image;
                                    $img_alt = $name;
                                }
                                echo '<img src="'.esc_url($img_url).'" alt="'.esc_attr($img_alt).'" width="231" height="231">';
                            }
                            ?>
                        </div>
                        <div class="ing-text">
                            <?php if ($name): ?>
                                <h3><?php echo $i; ?>. <?php echo esc_html($name); ?></h3>
                            <?php endif; ?>

                            <?php if ($description): ?>
                                <p><?php echo esc_html($description); ?></p>
                            <?php endif; ?>

                            <?php if ($benefits): ?>
                                <h4>Health Benefits</h4>
                                <ul>
                                    <?php foreach (preg_split('/\r\n|\r|\n/', $benefits) as $benefit): ?>
                                        <?php if (trim($benefit)): ?>
                                            <li>&#8226; <?php echo esc_html($benefit); ?></li>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </ul>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endfor; ?>
        </div>

        <!-- Aromatic Herbs -->
        <input type="checkbox" id="aromatic-herbs">
        <label for="aromatic-herbs">
            <h2>aromatic herbs</h2>
        </label>
        <div class="accordion-content">
            <?php for ($i = 1; $i <= 20; $i++): 
                $image       = get_field("aromatic_herb_{$i}_image");
                $name        = get_field("aromatic_herb_{$i}_name");
                $description = get_field("aromatic_herb_{$i}_description");
                $benefits    = get_field("aromatic_herb_{$i}_benefits");

                if (empty($name) && empty($image) && empty($description) && empty($benefits)) continue;
            ?>
                <div class="ingredient-item">
                    <div class="ing-content">
                        <div class="ing-img">
                            <?php 
                            if ($image) {
                                if (is_array($image)) {
                                    $img_url = $image['url'];
                                    $img_alt = $image['alt'] ?: $name;
                                } else {
                                    $img_url = $image;
                                    $img_alt = $name;
                                }
                                echo '<img src="'.esc_url($img_url).'" alt="'.esc_attr($img_alt).'" width="231" height="231">';
                            }
                            ?>
                        </div>
                        <div class="ing-text">
                            <?php if ($name): ?>
                                <h3><?php echo $i; ?>. <?php echo esc_html($name); ?></h3>
                            <?php endif; ?>

                            <?php if ($description): ?>
                                <p><?php echo esc_html($description); ?></p>
                            <?php endif; ?>

                            <?php if ($benefits): ?>
                                <h4>Health Benefits</h4>
                                <ul>
                                    <?php foreach (preg_split('/\r\n|\r|\n/', $benefits) as $benefit): ?>
                                        <?php if (trim($benefit)): ?>
                                            <li>&#8226; <?php echo esc_html($benefit); ?></li>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </ul>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endfor; ?>
        </div>

        <!-- Seeds & Pods -->
        <input type="checkbox" id="seeds-pods">
        <label for="seeds-pods">
            <h2>seeds &#38; pods</h2>
        </label>
        <div class="accordion-content">
            <?php for ($i = 1; $i <= 20; $i++): 
                $image       = get_field("seed_pod_{$i}_image");
                $name        = get_field("seed_pod_{$i}_name");
                $description = get_field("seed_pod_{$i}_description");
                $benefits    = get_field("seed_pod_{$i}_benefits");

                if (empty($name) && empty($image) && empty($description) && empty($benefits)) continue;
            ?>
                <div class="ingredient-item">
                    <div class="ing-content">
                        <div class="ing-img">
                            <?php 
                            if ($image) {
                                if (is_array($image)) {
                                    $img_url = $image['url'];
                                    $img_alt = $image['alt'] ?: $name;
                                } else {
                                    $img_url = $image;
                                    $img_alt = $name;
                                }
                                echo '<img src="'.esc_url($img_url).'" alt="'.esc_attr($img_alt).'" width="231" height="231">';
                            }
                            ?>
                        </div>
                        <div class="ing-text">
                            <?php if ($name): ?>
                                <h3><?php echo $i; ?>. <?php echo esc_html($name); ?></h3>
                            <?php endif; ?>

                            <?php if ($description): ?>
                                <p><?php echo esc_html($description); ?></p>
                            <?php endif; ?>

                            <?php if ($benefits): ?>
                                <h4>Health Benefits</h4>
                                <ul>
                                    <?php foreach (preg_split('/\r\n|\r|\n/', $benefits) as $benefit): ?>
                                        <?php if (trim($benefit)): ?>
                                            <li>&#8226; <?php echo esc_html($benefit); ?></li>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </ul>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endfor; ?>
        </div>

        <!-- Specialty Ingredients -->
        <input type="checkbox" id="specialty-ingredients">
        <label for="specialty-ingredients">
            <h2>specialty ingredients</h2>
        </label>
        <div class="accordion-content">
            <?php for ($i = 1; $i <= 20; $i++): 
                $image       = get_field("specialty_{$i}_image");
                $name        = get_field("specialty_{$i}_name");
                $description = get_field("specialty_{$i}_description");
                $benefits    = get_field("specialty_{$i}_benefits");

                if (empty($name) && empty($image) && empty($description) && empty($benefits)) continue;
            ?>
                <div class="ingredient-item">
                    <div class="ing-content">
                        <div class="ing-img">
                            <?php 
                            if ($image) {
                                if (is_array($image)) {
                                    $img_url = $image['url'];
                                    $img_alt = $image['alt'] ?: $name;
                                } else {
                                    $img_url = $image;
                                    $img_alt = $name;
                                }
                                echo '<img src="'.esc_url($img_url).'" alt="'.esc_attr($img_alt).'" width="231" height="231">';
                            }
                            ?>
                        </div>
                        <div class="ing-text">
                            <?php if ($name): ?>
                                <h3><?php echo $i; ?>. <?php echo esc_html($name); ?></h3>
                            <?php endif; ?>

                            <?php if ($description): ?>
                                <p><?php echo esc_html($description); ?></p>
                            <?php endif; ?>

                            <?php if ($benefits): ?>
                                <h4>Health Benefits</h4>
                                <ul>
                                    <?php foreach (preg_split('/\r\n|\r|\n/', $benefits) as $benefit): ?>
                                        <?php if (trim($benefit)): ?>
                                            <li>&#8226; <?php echo esc_html($benefit); ?></li>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </ul>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endfor; ?>
        </div>

        <!-- Nuts & Enriching Elements -->
        <input type="checkbox" id="nuts-enriching">
        <label for="nuts-enriching">
            <h2>nuts &#38; enriching elements</h2>
        </label>
        <div class="accordion-content">
            <?php for ($i = 1; $i <= 20; $i++): 
                $image       = get_field("nuts_enriching_{$i}_image");
                $name        = get_field("nuts_enriching_{$i}_name");
                $description = get_field("nuts_enriching_{$i}_description");
                $benefits    = get_field("nuts_enriching_{$i}_benefits");

                if (empty($name) && empty($image) && empty($description) && empty($benefits)) continue;
            ?>
                <div class="ingredient-item">
                    <div class="ing-content">
                        <div class="ing-img">
                            <?php 
                            if ($image) {
                                if (is_array($image)) {
                                    $img_url = $image['url'];
                                    $img_alt = $image['alt'] ?: $name;
                                } else {
                                    $img_url = $image;
                                    $img_alt = $name;
                                }
                                echo '<img src="'.esc_url($img_url).'" alt="'.esc_attr($img_alt).'" width="231" height="231">';
                            }
                            ?>
                        </div>
                        <div class="ing-text">
                            <?php if ($name): ?>
                                <h3><?php echo $i; ?>. <?php echo esc_html($name); ?></h3>
                            <?php endif; ?>

                            <?php if ($description): ?>
                                <p><?php echo esc_html($description); ?></p>
                            <?php endif; ?>

                            <?php if ($benefits): ?>
                                <h4>Health Benefits</h4>
                                <ul>
                                    <?php foreach (preg_split('/\r\n|\r|\n/', $benefits) as $benefit): ?>
                                        <?php if (trim($benefit)): ?>
                                            <li>&#8226; <?php echo esc_html($benefit); ?></li>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </ul>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endfor; ?>
        </div>

    </section>
</main>
<!-- content END -->

<?php get_footer(); ?>
