document.addEventListener('DOMContentLoaded', function() {
    const recipeNav = document.querySelector('.recipe-nav');
    
    if (recipeNav) {
        const links = recipeNav.querySelectorAll('a');
        
        links.forEach(link => {
            const linkText = link.textContent.trim();

            // Check if it's a "Previous Chai" link
            if (linkText.includes('Previous Chai') || linkText.includes('←')) {
                link.setAttribute('data-nav', 'previous');
            }
            
            // Check if it's a "Next Chai" link
            if (linkText.includes('Next Chai') || linkText.includes('→')) {
                link.setAttribute('data-nav', 'next');
            }
        });
    }
});