<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php wp_title(''); ?></title>
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<!-- wrapper START -->
<div id="wrap">

    <!-- masthead -->
    <header role="banner">
        <a class="skip" href="#nav" accesskey="2">Skip to navigation</a>
        <a class="skip" href="#content" accesskey="3">Skip to main content</a>

        <!-- LOGO -->
        <div>
            <a href="<?php echo esc_url(home_url('/')); ?>" title="<?php bloginfo('name'); ?>">
                <?php
                if (function_exists('the_custom_logo') && has_custom_logo()) {
                    the_custom_logo();
                } else {
                    // Fallback logo
                    echo '<img src="' . get_template_directory_uri() . '/assets/chaiblend_logo.svg" alt="' . esc_attr(get_bloginfo('name')) . ' logo" width="848" height="531">';
                }
                ?>
            </a>
        </div>
        <!-- End LOGO -->
    </header>

    <!-- Navigation Menu -->
    <nav id="nav" role="navigation" aria-label="main menu">
        <input id="menu-toggle" type="checkbox">
        <label for="menu-toggle" class="toggle">menu</label>
        <?php wp_nav_menu( array( 'theme_location' => 'sitenav', 'container' => '', ) ); ?>
    </nav>
