<?php
# ------------------------------------------
# ADD SCRIPTS
# ------------------------------------------
function theming_scripts() {
// CSS
	wp_enqueue_style( 'stylesheet', get_stylesheet_uri() );
//	wp_enqueue_style( 'custom-style', get_template_directory_uri() . '/css/custom.css' );	
//	fonts
	wp_enqueue_style( 'karla-font', 'https://fonts.googleapis.com/css2?family=Karla:ital,wght@0,200..800;1,200..800&display=swap', false );
    wp_enqueue_style( 'playfair-font', 'https://fonts.googleapis.com/css2?family=Playfair+Display:ital,wght@0,400..900;1,400..900&display=swap', false );

// JS
    wp_enqueue_script( 'recipe-nav-js', get_template_directory_uri() . '/js/link.js', array(), '', true );
}
add_action( 'wp_enqueue_scripts', 'theming_scripts' );

# remove smilies/emoticon horridness
function cb_remove_smileys($bool) {
  return false;
}
add_filter('option_use_smilies','cb_remove_smileys',99,1);

# ------------------------------------------
# REGISTER SITE MENUS
# ------------------------------------------
if (function_exists( 'add_theme_support' )) {
	register_nav_menus(
	    array(
	        'sitenav' => __( 'Site nav' ),
	        'footnav' => __( 'Footer nav' )
	    )
	);
}

# ------------------------------------------
# REMOVE DEFAULT MENU CONTAINER
# ------------------------------------------
function my_wp_nav_menu_args( $args = '' ) {
    $args['container'] = false;
    return $args;
}
add_filter( 'wp_nav_menu_args', 'my_wp_nav_menu_args' );

# ------------------------------------------
# ALLOW SVG UPLOADS
# ------------------------------------------
add_filter('upload_mimes', function($mimes) {
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
});

# ------------------------------------------
# Redirect category archive pages to /chai-recipes/
# ------------------------------------------
function redirect_category_archives() {
    if ( is_category() ) {
        wp_redirect( home_url( '/chai-recipes' ), 301 );
        exit;
    }
}
add_action( 'template_redirect', 'redirect_category_archives' );

# ------------------------------------------
# Enable featured images
# ------------------------------------------
add_theme_support( 'post-thumbnails' );
