<?php
get_header();
?>

<!-- content START -->
<main>
    <section id="content" class="homepage">

        <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
            <h1><?php the_title(); ?></h1>
            <?php the_content(); ?>
        <?php endwhile; endif; ?>

        <!-- Illustration -->
        <figure>
            <img src="<?php echo get_template_directory_uri(); ?>/assets/welcome-illustration.svg" alt="Illustration of hands holding a warm cup of chai tea with star anise">
        </figure>
        
        <!-- Recipes CTA -->
        <a href="<?php echo esc_url( home_url('/chai-recipes') ); ?>">
            Explore Chai Recipes &#8594;
        </a>

        <!-- Learn More Section -->
        <h2>Learn More About Chai</h2>
        <div>
            <div>
                <a href="<?php echo esc_url( home_url('/chai-equipment') ); ?>" title="Chai Equipment">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/saucepan-silhouette-illustration.svg" 
                         alt="Illustration of saucepan silhouette" width="332" height="332">
                    <p>chai equipment</p>
                </a>
            </div>
            <div>
                <a href="<?php echo esc_url( home_url('/types-of-tea') ); ?>" title="Types of Tea">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/tea-leaves-silhouette-illustration.svg" 
                         alt="Illustration of tea leaves silhouette" width="332" height="332">
                    <p>types of tea</p>
                </a>
            </div>
            <div>
                <a href="<?php echo esc_url( home_url('/the-chaiwala') ); ?>" title="The Chaiwala">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/mustache-silhouette-illustration.svg" 
                         alt="Illustration of mustache silhouette" width="332" height="332">
                    <p>the chaiwala</p>
                </a>
            </div>
            <div>
                <a href="<?php echo esc_url( home_url('/the-history-of-chai') ); ?>" title="The History of Chai">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/teapot-silhouette-illustration.svg" 
                         alt="Illustration of teapot silhouette" width="332" height="332">
                    <p>the history of chai</p>
                </a>
            </div>
        </div>

        <!-- Health Benefits -->
        <h2>Discover The Health Benefits Of Chai</h2>
        <p>
            Chai is more than taste - it's wellness in a cup. From spices and herbs to seeds and special blends, 
            each ingredient brings its own natural benefits that help the body, calm the mind, and nourish the spirit.
        </p>
        <a href="<?php echo esc_url( home_url('/health-benefits') ); ?>">
            Explore Health Benefits &#8594;
        </a>
    </section>
</main>
<!-- content END -->

<?php get_footer(); ?>