<?php get_header(); ?>

<main>
    <section id="content" class="error-page">
        <figure>
            <img src="<?php echo get_template_directory_uri(); ?>/assets/error-illustration.svg" 
                 alt="Illustration of 404 error" width="1268" height="512">
        </figure>

        <h1>Sorry! We can't find that page.</h1>
        <p>Looks like the page you're searching for has gone cold - but don't worry, there's still the warmth of chai culture here waiting for you at Chaiblend. Maybe one of the links below will help :</p>
        <ul>
            <li><a href="<?php echo home_url(); ?>">Home</a></li>
            <li><a href="<?php echo home_url('/what-is-chai-meaning'); ?>">What Is Chai?</a></li>
            <li><a href="<?php echo home_url('/chai-recipes'); ?>">Chai Recipes</a></li>
        </ul>

        <div class="search-container">
            <label for="search-input" class="search-label">
                Or try searching below to find your perfect cup of content :
            </label>
            <?php get_search_form(); ?>
        </div>
    </section>
</main>

<?php get_footer(); ?>


